set serveroutput on size 100000
declare
  l_owner varchar2(32) := 'SH';
  l_object_name varchar2(32) :='SALES';
  l_partition_name varchar2(32) :='SALES_Q1_2000';
  l_quantity_sold number;
begin
  for c1 in (
    select dbms_rowid.rowid_create ( rowid_type, data_object_id , relative_fno, block_id, row_number ) row_id,
    data_object_id, relative_fno , block_id, row_number
    from (
     select 
          dbms_rowid.rowid_type(rowid) rowid_type,
          dbms_rowid.rowid_object(rowid) data_object_id,
          dbms_rowid.rowid_relative_fno(rowid) relative_fno,
          dbms_rowid.rowid_block_number(rowid) block_id,
          min(dbms_rowid.rowid_row_number(rowid)) row_number
     from sh.sales partition ( SALES_Q1_2000 )
     group by
          dbms_rowid.rowid_type(rowid),
          dbms_rowid.rowid_object(rowid) ,
          dbms_rowid.rowid_relative_fno(rowid) ,
          dbms_rowid.rowid_block_number(rowid) 
     order by 1,2,3
     )
   )
  loop  
   begin
     --dbms_output.put_line ( 'rowid '|| c1.row_id ||' ' ||c1.relative_fno ||' ' ||c1.block_id ||' '||c1.row_number );
     select quantity_sold into l_quantity_sold from sh.sales partition ( SALES_Q1_2000)
     where rowid=c1.row_id;
     --dbms_output.put_line ( c1.row_id || ' ' ||l_quantity_sold);
   exception
    when SYS_INVALID_ROWID then   
     dbms_output.put_line ( 'Invalid rowid '|| c1.row_id ||' ' ||c1.relative_fno ||' ' ||c1.block_id );
   end;
  end loop;
end ;
/
