REM Demo for how OIB session reading base table in current mode, look for CR_SCN_BAS from x$BH

drop table oib1 purge;

create table oib1 as select rownum a, rownum b from dual connect by level <= 250000;

conn / as sysdba

select cr_scn_bas, file#, class, state, count(*) from x$bh
where obj in (select max(data_object_id) from dba_objects where object_name='OIB1')
group by cr_scn_bas, file#, class, state
order by 1, 2
/

connect test/test

alter session set db_file_multiblock_read_count=16;

create index oib1_idx on oib1(a) online;

connect / as sysdba

select cr_scn_bas, file#, class, state, count(*) from x$bh
where obj in (select max(data_object_id) from dba_objects where object_name='OIB1')
group by cr_scn_bas, file#, class, state
order by 1, 2
/