-- ************************************************************************
-- This file contains a snippet of code from the show procedure.
-- Custom code added to the package is shown between Custom Code comments
-- This code processes errors and shows an error page with a Back button
-- ************************************************************************
--
    validity_check('P_P_REPORT_TYPE_SELECT',L_P_P_REPORT_TYPE_SELECT);
    validity_check('P_P_GENERIC_FROM_DATE',L_P_P_GENERIC_FROM_DATE);
    validity_check('P_P_GENERIC_THRU_DATE',L_P_P_GENERIC_THRU_DATE);
    validity_check('P_P_USERNAME',L_P_P_USERNAME);
    validity_check('P_USERPARAM',L_P_USERPARAM);

-- *** Custom code
-- code for validation:
--
    DECLARE
      v_errornames  wwv_utl_api_types.empty_vc_arr%TYPE DEFAULT wwv_utl_api_types.empty_vc_arr;
      v_errorvalues wwv_utl_api_types.empty_vc_arr%TYPE DEFAULT wwv_utl_api_types.empty_vc_arr;
      x INTEGER;

    BEGIN
       -- Validate that From Date is before Thru Date
       IF L_P_P_GENERIC_FROM_DATE IS NOT NULL AND
           L_P_P_GENERIC_THRU_DATE IS NOT NULL
       THEN
          IF ((reports_validation_pkg.DATEFORMAT_VALIDATION(L_P_P_GENERIC_FROM_DATE,'Start Date')) AND
   	      (reports_validation_pkg.DATEFORMAT_VALIDATION(L_P_P_GENERIC_THRU_DATE,'Through Date')))
          THEN
             reports_validation_pkg.VALIDATE_DATE_ORDER(L_P_P_GENERIC_FROM_DATE,L_P_P_GENERIC_THRU_DATE,'Start Date','Through Date');
   	      END IF;
       END IF;

                               
      END IF;
    END IF;

       -- Populate the default portal error handler with our error messages
       IF reports_validation_pkg.HAS_ERRORS
       THEN
          reports_validation_pkg.get_errors(v_errornames, v_errorvalues);
          x := v_errornames.FIRST;
          WHILE x IS NOT NULL
          LOOP
             g_invalidnumber := g_invalidnumber+1;
             g_invalidnames(g_invalidnumber) := v_errornames(x);
             g_invalidvalues(g_invalidnumber) := v_errorvalues(x);
             x := v_errornames.NEXT(x);
          END LOOP;
       END IF;
    END;

    -- get the Portal username into the username parameter
    L_P_P_USERNAME := wwctx_api.get_user;
--
-- **** Custom code end
--
    g_arrayfilled := 0;
    IF g_invalidnumber>0 THEN
--
-- header
--
PORTAL.wwv_headings.show_header(
    p_template => 'PUBLIC.OASAS_REPORTS_TEMPLATE',
    p_heading => 'Oracle Report Parameters',
    home_link => 'OASASREP.CDSRPADM101.help',
    p_help_link => '    ',
    p_about_link => '');

-- *** Custom Code
    htp.p('<FONT COLOR="RED">');
-- *** Custom code end

    PORTAL.rwrunrpterr.show (
        p_invalid_name => g_invalidnames,
        p_invalid_val => g_invalidvalues
    );

-- *** Custom code
   htp.p('</FONT>');
	htp.p('<input type="button" value="Back" onclick="history.back()">');
-- *** Custom code end

-- ************************************************************************
--
-- This section shows the reports_validation package called above
--
-- dateformat_validation
-- get_errors
-- has_errors
-- validate_date_order
--
-- ************************************************************************
CREATE OR REPLACE PACKAGE reports_validation_pkg
AS
   g_invalidnames    portal.wwv_utl_api_types.empty_vc_arr%TYPE;
   g_invalidvalues   portal.wwv_utl_api_types.empty_vc_arr%TYPE;
   g_invalidnumber     NUMBER  := 0;
   g_testnumber NUMBER := g_invalidnumber;
   g_date_format_mask  VARCHAR2(15) := 'MM/DD/YYYY';
   g_month_year_mask   VARCHAR2(15) := 'MM/YYYY';
   --
 
   FUNCTION dateformat_validation (
      p_date     IN   VARCHAR2,
      p_prompt   IN   VARCHAR2 DEFAULT '<<Replace Prompt>>',
   	p_check_for_null IN VARCHAR2 DEFAULT 'Y',
      p_debug    IN   BOOLEAN DEFAULT FALSE
   )
       RETURN BOOLEAN;

   PROCEDURE get_errors (
      v_errornames    OUT   wwv_utl_api_types.empty_vc_arr%TYPE,
      v_errorvalues   OUT   wwv_utl_api_types.empty_vc_arr%TYPE
   );

   FUNCTION has_errors
      RETURN BOOLEAN;

   PROCEDURE validate_date_order (
      p_start_date     IN   VARCHAR2,
      p_end_date       IN   VARCHAR2,
      p_start_prompt   IN   VARCHAR2 DEFAULT '<<Replace Prompt>>',
      p_end_prompt     IN   VARCHAR2 DEFAULT '<<Replace prompt>>',
      p_debug          IN   BOOLEAN DEFAULT FALSE
   );

END;

CREATE OR REPLACE PACKAGE BODY reports_validation_pkg
AS

   FUNCTION dateformat_validation(
         p_date IN VARCHAR2,
         p_prompt IN VARCHAR2 DEFAULT '<<Replace Prompt>>',
      	p_check_for_null IN VARCHAR2 DEFAULT 'Y',
         p_debug IN BOOLEAN DEFAULT FALSE) RETURN BOOLEAN
   IS

       TYPE DayType IS TABLE OF NUMBER;
       TYPE MonthType IS TABLE OF VARCHAR2(2);
       DayArray DayType;
       MonthArray MonthType;
       thisYear VARCHAR2(4);
       thisMonth VARCHAR2(2);
       thisDay VARCHAR2(2);
       N NUMBER;
       filter VARCHAR2(100);
       v_return   BOOLEAN := TRUE;
   BEGIN
      DayArray := DayType(31,28,31,30,31,30,31,31,30,31,30,31);
      MonthArray := MonthType('01','02','03','04','05','06','07','08','09','10','11','12');

      -- This function handles only the MM/DD/YYYY format.It also checks for Leap Year
      IF p_debug THEN
           dbms_output.put_line('Enter a Date for ' || p_date);
      END IF;

      -- Check if the date is null (and we do not want it to be NULL)
      IF (p_check_for_null = 'Y') AND p_date IS NULL
      THEN
         add_error('Enter a Date for '||p_prompt, p_date);
     	   v_return := FALSE;
      ELSIF p_date IS NULL
      THEN  -- date is null and check for null = N, no need to do anything
         v_return := TRUE;
      ELSE  -- date is not null, regardless of check_for_null
         thisMonth := SUBSTR(p_date,1,2);
         thisDay   := SUBSTR(p_date,4,2);
         thisYear  := SUBSTR(p_date,7,4);

         IF p_debug THEN
           dbms_output.put_line('Date parsed for ' || p_date || ' ** Month=' || thisMonth || ' Day=' || thisDay || ' Year=' || thisYear);
         END IF;

         filter := '^[0-9]{2}/[0-9]{2}/[0-9]{4}$';
         IF NOT (owa_pattern.match(p_date, filter)) THEN
           add_error('Enter ' || p_prompt || ' in '||g_date_format_mask||' format - ', p_date);

           IF p_debug THEN
             dbms_output.put_line('Date filter ( ' || filter || ' ) did not match for ' || p_date );
           END IF;

      	  v_return := FALSE;
         ELSE
           -- Check Valid Month
           -- this doesn't work: filter := '[01|02|03|04|05|06|07|08|09|10|11|12]';
           --                    IF NOT (owa_pattern.match(thisMonth, filter)) then
            IF thisMonth NOT IN ('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '11', '12')
            THEN
              add_error('Enter the Correct Month for ' || p_prompt || ' - ', p_date);
              IF p_debug THEN
                dbms_output.put_line('Month filter ( ' || filter || ' ) did not match, invalid value: ' || thisMonth );
              END IF;

         	  v_return := FALSE;
           ELSE
              /* Check For Leap Year */
              N := TO_NUMBER(thisYear);
              IF ( ((MOD(N,4)=0) AND (MOD(N,100) <> 0)) OR (MOD(N,400)=0) ) THEN
                DayArray(2) := 29;
              END IF;

              /* Check for valid days for month */
              FOR i IN 1..12
              LOOP
                IF MonthArray(i)=thisMonth
                THEN
            	   IF (thisDay <= DayArray(i) AND thisDay > 0)
            	   THEN
            		   v_return := TRUE;
            		   EXIT;
            		ELSE
                     add_error('Enter a valid Day for ' || p_prompt || ' - ', p_date);
            		   v_return := FALSE;
            		   EXIT;
            		END IF;   -- end of IF (thisDay <= DayArray(i) AND thisDay > 0)
         	    END IF;     -- end of IF MonthArray(i)=thisMonth
              END LOOP;
           END IF;  -- end of IF NOT (owa_pattern.match(thisMonth, filter))
         END IF;   -- end of if NOT (owa_pattern.match(p_date, filter))
      END IF;      -- end of IF (p_check_for_null='Y') AND p_date IS NULL
      RETURN v_return;
   END dateformat_validation;


   PROCEDURE get_errors (
      v_errornames    OUT   wwv_utl_api_types.empty_vc_arr%TYPE,
      v_errorvalues   OUT   wwv_utl_api_types.empty_vc_arr%TYPE
   )
   IS
      i   INTEGER;
   BEGIN
      i := g_invalidnames.FIRST;

      WHILE i IS NOT NULL
      LOOP
         v_errornames (i) := g_invalidnames (i);
         v_errorvalues (i) := g_invalidvalues (i);
         i := g_invalidnames.NEXT (i);
      END LOOP;
   END get_errors;


   FUNCTION has_errors
      RETURN BOOLEAN
   IS
   BEGIN
      -- Returns TRUE if there are errors
      IF g_invalidnumber > 0
      THEN
         RETURN TRUE;
      ELSE
         RETURN FALSE;
      END IF;
   END has_errors;


   PROCEDURE validate_date_order (
         p_start_date     IN   VARCHAR2,
         p_end_date       IN   VARCHAR2,
         p_start_prompt   IN   VARCHAR2 DEFAULT '<<Replace Prompt>>',
         p_end_prompt     IN   VARCHAR2 DEFAULT '<<Replace prompt>>',
         p_debug          IN   BOOLEAN DEFAULT FALSE
    )
    IS
    BEGIN
       IF (TO_DATE(p_start_date, g_date_format_mask) > TO_DATE(p_end_date, g_date_format_mask))
       THEN
          add_error(p_end_prompt || ' must be after ' ||
                                    p_start_prompt, p_start_date);
          IF p_debug
          THEN
             dbms_output.put_line('Error: '||p_end_prompt||' ('||p_end_date||
             ') should be after '||p_start_prompt||' ('||p_start_date||')');
   	    END IF;
   	 END IF;
    END validate_date_order;

END;