CREATE OR REPLACE PACKAGE reports_util_pkg
IS
/******************************************************************************\
|| Program:    reports_UTIL_PKG
|| System:     All
||
|| Description:
||   Program units used to draw and process the Item Statistics Report's 
||   parameter form. The Portal link calls the Portal dynamic form package
||   DEMO_SHUTTLE_DYNPAGE which calls show_item_stat in this package. It passes
||   show_item_stat a transaction type and this procedure displays the parameter 
||   form. The Run button in the form calls the show_the_report procedure in 
||   this package.
||
|| Schema: REP
||   This user must have private synonyms to all tables used in the code.
||
||
|| Modification History:
||   ------------------------------------------------------
||      Date         By            Remarks/Reason
||   ------------------------------------------------------
||     15-Jun-2004   a_developer   Created
||  
|| Global Variables:
||
|| Usage:
||   group_cgikey
||      This function accepts a parameter of the username and returns the cgikey 
||      parameter representing the connection to which the user is authorized
||      based on the user's enrollment in a group.
||
||   shuttle_control_javascript
||      Adds JavaScript to the page to support a "shuttle control" consisting
||      of two multi-select controls and a set of move buttons. See 
||      DEMO_SHUTTLE_FORM_PKG for a sample call. Call this in the header
||      if possible.
||
||   show_error_page
||      Display an error page with a heading passed in and the error text
||      loaded to the error array p_messages.
||
||   table_data_close;
||      Displays a TD closing tag. This is missing from the HTP package.
||
||   table_data_open
||      Displays a TD open tag. This is missing from the HTP package.
||
||   template_copyright
||      Displays the  copyright line for the bottom of the page.
||
||   template_footer
||      Paints the bottom blue line optionially with buttons. If the button 
||      labels are not supplied, it does not draw the buttons.
||
||   template_header
||      Paints the top blue line optionially with buttons. If the button 
||      labels are not supplied, it does not draw the buttons.
\*****************************************************************************/

   FUNCTION group_cgikey(
      p_username  VARCHAR2)
      RETURN VARCHAR2;
   
   PROCEDURE show_error_page(
      p_heading      VARCHAR2,
      p_messages     portal.wwv_utl_api_types.empty_vc_arr%TYPE);

   PROCEDURE shuttle_control_javascript;

   PROCEDURE table_data_close;

   PROCEDURE table_data_open(
      p_attributes  VARCHAR2 DEFAULT NULL);

   PROCEDURE template_copyright;

   PROCEDURE template_footer(
      p_ok_button VARCHAR2 DEFAULT NULL,
      p_cancel_button VARCHAR2 DEFAULT NULL);
      
   PROCEDURE template_header(
      p_title VARCHAR2,
      p_ok_button VARCHAR2 DEFAULT NULL,
      p_cancel_button VARCHAR2 DEFAULT NULL);
   
END;
/

CREATE OR REPLACE PACKAGE BODY reports_util_pkg
IS

   FUNCTION group_cgikey(
      p_username  VARCHAR2)
      RETURN VARCHAR2
   IS
      v_return VARCHAR2(100);
   BEGIN
      IF wwsec_api.is_user_in_group(
            p_person_id => wwsec_api.id(UPPER(p_username)),
            p_group_id => wwsec_api.group_id('PRD_REPORTS')) 
      THEN
         v_return := 'prdrep';
      ELSIF wwsec_api.is_user_in_group(
            p_person_id => wwsec_api.id(UPPER(p_username)),
            p_group_id => wwsec_api.group_id('TEST_REPORTS')) 
      THEN
         v_return := 'reptest';
      ELSIF wwsec_api.is_user_in_group(
            p_person_id => wwsec_api.id(UPPER(p_username)),
            p_group_id => wwsec_api.group_id('TRNG_REPORTS')) 
      THEN
         v_return := 'reptrng';
      ELSE
         v_return := 'no_cgikey_found';
      END IF;
      --
      RETURN v_return;
   EXCEPTION
      WHEN OTHERS
      THEN
         RAISE_APPLICATION_ERROR(-20011, 'Error in GROUP_CGIKEY: '|| SQLERRM);
   END;
   

   PROCEDURE show_error_page(
      p_heading      VARCHAR2,
      p_messages     portal.wwv_utl_api_types.empty_vc_arr%TYPE)
   IS
   BEGIN
--      htp.htmlOpen;
      
      
      PORTAL.wwv_headings.show_header(
         p_template => 'PUBLIC.BLANK_REPORTS_TEMPLATE');      
      htp.headclose;
      htp.bodyOpen(  cattributes => ' bgcolor="#FFFFFF"' );
      htp.print( '<CENTER>' );

      -- header elements    
      template_header(p_heading , NULL, NULL);
      htp.p('<FONT COLOR="RED">');
      
      -- show errors and button
      FOR i IN 1 .. p_messages.COUNT
      LOOP     
         htp.p(p_messages(i) || htf.br);
      END LOOP;
      htp.p('</FONT>');
      htp.formOpen( curl => '', cmethod => 'get', cattributes => ' name="edit_page"');
      htp.p('<input type="button" value="Back" onclick="history.back()">'); 
      htp.formClose;

      -- footer and copyright
      template_footer(NULL, NULL);
      template_copyright;      
      htp.print( '</CENTER>' );
      htp.bodyClose;
      
      PORTAL.wwv_headings.show_footer(
         p_template => 'PUBLIC.BLANK_REPORTS_TEMPLATE');
      
--      htp.htmlClose;
   END;
   
   
   
   PROCEDURE shuttle_control_javascript
   IS
   BEGIN
      htp.print('<NOSCRIPT></NOSCRIPT>' );
      htp.print( '<SCRIPT TYPE="text/javascript">' );
      htp.print( '<!-- Comment out script for old browsers'); 
      htp.print('function swap(e1, e2)' ); 
      htp.print('{' ); 
      htp.print('  ttext = e1.text;' ); 
      htp.print('  tvalue = e1.value;' ); 
      htp.print('  e1.text = e2.text;' ); 
      htp.print('  e1.value = e2.value;' ); 
      htp.print('  e2.text = ttext;' ); 
      htp.print('  e2.value = tvalue;' ); 
      htp.print('} ' ); 
      htp.print('function deleteBlankRowIfNotEmpty(list)' ); 
      htp.print('{' ); 
      htp.print('   var idx = -1;' ); 
      htp.print('   var val = "";' ); 
      htp.print('// find a blank row in table ' ); 
      htp.print('   for (i = 0; i < list.length; i++){ ' ); 
      htp.print('        val = list.options[i].value;' ); 
      htp.print('        if (val == "") {' ); 
      htp.print('           idx = i;' ); 
      htp.print('           break;' ); 
      htp.print('        }' ); 
      htp.print('   } ' ); 
      htp.print('   if (idx >= 0 && (list.length > 1))' ); 
      htp.print('      list.options[idx] = null;' ); 
      htp.print('}' ); 
      htp.print('function selectAll(list)' ); 
      htp.print('{' ); 
      htp.print('  for ( i = 0; i <= list.length-1; i++ )' ); 
      htp.print('    list.options[i].selected = true;' ); 
      htp.print('  return true;' ); 
      htp.print('}' ); 
      htp.print('function unSelectAll(list)' ); 
      htp.print('{' ); 
      htp.print('  for ( i = 0; i <= list.length-1; i++ )' ); 
      htp.print('    list.options[i].selected = false;' ); 
      htp.print('  return true;' ); 
      htp.print('}' ); 
      htp.print('function clearList(list)' ); 
      htp.print('{' ); 
      htp.print('  list.length = 0;' ); 
      htp.print('}' ); 
      htp.print('function copyToList(fromList, toList, direction) {' ); 
      htp.print('  for ( i = 0; i <= fromList.length-1;) {' ); 
      htp.print('    if (fromList.options[i].selected) {' ); 
      htp.print('        txt = fromList.options[i].text;' ); 
      htp.print('        val = fromList.options[i].value;' ); 
      htp.print('        if ( val != "" ) {' ); 
      htp.print('           // check if value is a spacer' ); 
      htp.print('           if ( val == "spacer" ) {' ); 
      htp.print('                if ( direction == "left" ) {' ); 
      htp.print('                     // remove from right and do not add on left' ); 
      htp.print('                     fromList.options[i]= null;' ); 
      htp.print('                }   ' ); 
      htp.print('                else {' ); 
      htp.print('                    // add to right but do not remove from left' ); 
      htp.print('                    fromList.options[i].selected = false;' ); 
      htp.print('                    toList.options[toList.length] = new Option( txt, val, false, true );' ); 
      htp.print('                    toList.options[toList.selectedIndex].selected = false;' ); 
      htp.print('                }' ); 
      htp.print('           }' ); 
      htp.print('           else {  //only increment when not moving and deleting' ); 
      htp.print('             // create a new row' ); 
      htp.print('             toList.options[toList.length] = new Option( txt, val, false, true );' ); 
      htp.print('             // added these lines' ); 
      htp.print('             // removes from fromList and unselects item in toList' ); 
      htp.print('             fromList.options[i]= null;' ); 
      htp.print('             toList.options[toList.selectedIndex].selected = false;' ); 
      htp.print('           }  //only increment when not moving and deleting' ); 
      htp.print('        } else {' ); 
      htp.print('            i++; // increment when selected element is empty' ); 
      htp.print('        }' ); 
      htp.print('    }' ); 
      htp.print('    else i++;  //only increment when not moving and deleting' ); 
      htp.print('  }' ); 
      htp.print('  deleteBlankRowIfNotEmpty(fromList);' ); 
      htp.print('  deleteBlankRowIfNotEmpty(toList);' ); 
      htp.print('  // Set the order' ); 
      htp.print('  newOrder(toList, eval("document." + toList.form.name + "." + toList.name.substr(0, toList.name.lastIndexOf("select"))));' ); 
      htp.print('  newOrder(fromList, eval("document." + fromList.form.name + "." + fromList.name.substr(0, fromList.name.lastIndexOf("select"))));' );
      htp.print('}' ); 
      htp.print('function copyAll(fromList, toList, direction) {' ); 
      htp.print('     indexofspacer = -1;' ); 
      htp.print('        spacerval = "";' ); 
      htp.print('        spacertxt = "";' ); 
      htp.print('        indexofitem = toList.length;' ); 
      htp.print('     for ( i = 0; i <= fromList.length-1; i++ ) {' ); 
      htp.print('         txt = fromList.options[i].text;' ); 
      htp.print('         val = fromList.options[i].value;' ); 
      htp.print('         if ( val != "" ) {' ); 
      htp.print('             // check if we need to copy the spacer too' ); 
      htp.print('             if ( val != "spacer") {' ); 
      htp.print('                  toList.options[indexofitem] = new Option( txt, val, false, true );' ); 
      htp.print('                  toList.options[indexofitem].selected = false;' ); 
      htp.print('                     indexofitem++;' ); 
      htp.print('                }' ); 
      htp.print('                else { // found a spacer' ); 
      htp.print('                    indexofspacer = i;' ); 
      htp.print('                    spacerval = val;' ); 
      htp.print('                    spacertxt = txt;' ); 
      htp.print('                }' ); 
      htp.print('            }' ); 
      htp.print('     }   ' ); 
      htp.print('        if (indexofspacer != -1 && direction == "right" ) // let the spacer be on the from '|| 
               'list' ); 
      htp.print('            fromList.length = 1;' ); 
      htp.print('        else' ); 
      htp.print('         clearList(fromList);' ); 
      htp.print('     deleteBlankRowIfNotEmpty(toList);' ); 
      htp.print('     unSelectAll(toList);' ); 
      htp.print('     // Set the order' ); 
      htp.print('     newOrder(toList, eval("document." + toList.form.name + "." + toList.name.substr(0, toList.name.lastIndexOf("select"))));' ); 
      htp.print('     newOrder(fromList, eval("document." + fromList.form.name + "." + fromList.name.substr(0, ' || 
            'fromList.name.lastIndexOf("select"))));' ); 
      htp.print('}' ); 
      htp.print(' function newOrder(list, csv) { ' ); 
      htp.print('    csv.value = "";' ); 
      htp.print('    for (var i = 0; i <= list.length - 1; i++){ ' ); 
      htp.print('        if (list.options[i].value != "") { ' ); 
      htp.print('           csv.value += list.options[i].value;' ); 
      htp.print('           if (i < list.length - 1 && list.options[i+1].value != "") ' ); 
      htp.print('              csv.value += ",";' ); 
      htp.print('        } ' ); 
      htp.print('    } ' ); 
      htp.print(' } ' ); 
      htp.print(' function sortList(checked, list, sortedList)' ); 
      htp.print('         {' ); 
      htp.print('           if (!checked) return;' ); 
      htp.print('           var sortKeys = new Array();' ); 
      htp.print('           // Get the sort key of each value in the list.' ); 
      htp.print('           // If the list is updated below, this list is reordered as well.' ); 
      htp.print('           for (var i=0; i < list.length; i++)' ); 
      htp.print('             for (var j=0; j < sortedList.length; j++)' ); 
      htp.print('               if (sortedList[j] == list.options[i].value)' ); 
      htp.print('                 sortKeys[i] = j;' ); 
      htp.print('           // Sort the HTML list according to the sortKeys.' ); 
      htp.print('           for (var i=0; i < list.length; i++)' ); 
      htp.print('           {' ); 
      htp.print('             // Find the list element with the lowest sort index.' ); 
      htp.print('             var min = i;' ); 
      htp.print('             for (var j=i+1; j < list.length; j++)' ); 
      htp.print('               if (sortKeys[j] < sortKeys[min])' ); 
      htp.print('                 min = j;' ); 
      htp.print('             // If we found one, swap the list elements.' ); 
      htp.print('             if (min != i)' ); 
      htp.print('             {' ); 
      htp.print('               swap(list.options[i], list.options[min]);' ); 
      htp.print('               var tmp = sortKeys[i];' ); 
      htp.print('               sortKeys[min] = sortKeys[i];' ); 
      htp.print('               sortKeys[i] = tmp;' ); 
      htp.print('             }' ); 
      htp.print('           }' ); 
      htp.print('         }' ); 
      htp.print('//-->' );
      htp.print( '</SCRIPT>' );
   END;

   
   PROCEDURE table_data_close
   IS
   BEGIN
      htp.p('</TD>');
   END;

   
   PROCEDURE table_data_open(
      p_attributes  VARCHAR2 DEFAULT NULL)
   IS
   BEGIN
      htp.p('<TD '|| p_attributes || '>');
   END;

   
   PROCEDURE template_copyright
   IS
   BEGIN
      htp.tableOpen( calign => 'CENTER', cattributes => ' cellspacing="0" cellpadding="0" width="90%"' );
      htp.tableRowOpen;
      htp.tableData( 'Office of Alcoholism and Substance Abuse Services, New York State. All Rights Reserved.    ' || 
          '       ', calign => 'LEFT', cattributes => ' class="OraCopyright"');
      htp.tableRowClose;
      htp.tableClose;
   END;


   PROCEDURE template_footer(
      p_ok_button VARCHAR2 DEFAULT NULL,
      p_cancel_button VARCHAR2 DEFAULT NULL)
   IS
   BEGIN
      -- Bottom buttons
      htp.br;
      htp.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0" width="90%"' );
      htp.tableRowOpen;
      htp.tableData( htf.img( '/images/pobtrans.gif', cattributes => ' width="1" height="8"'));
      htp.tableRowClose;
      
      IF p_ok_button IS NOT NULL
      THEN 
         htp.tableRowOpen;
         htp.tableData( htf.tableOpen( calign => 'right',
               cattributes => ' border="0" cellpadding="1" cellspacing="4"' ) || 
            htf.tableRowOpen || 
            htf.tableData(p_ok_button) || 
            htf.tableData(p_cancel_button) || 
            htf.tableRowClose || 
            htf.tableClose, calign => 'RIGHT', cattributes => ' valign="TOP" width="100%"');
         htp.tableRowClose;
      END IF;
      
      htp.tableRowOpen;

      -- Bottom blue line
      htp.tableData( htf.tableOpen(  cattributes => ' width="100%" border="0" cellpadding="0" cellspacing="0"' ) || 
         htf.tableRowOpen || 
         htf.tableData( htf.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0"' ) || 
         htf.tableRowOpen || 
         htf.tableData( htf.img( '/images/FFFFFFbr.gif', calt => ''), calign => 'RIGHT', cattributes => ' class="OraBgColorDark"') || 
         htf.tableRowClose || 
         htf.tableClose, calign => 'RIGHT') || 
         htf.tableRowClose || 
         htf.tableRowOpen || 
         htf.tableData( '&nbsp;', cattributes => ' height="14" class="OraBgColorDark"') || 
         htf.tableRowClose || 
         htf.tableClose);
      htp.tableRowClose;
      htp.tableClose;
   END;
   

   PROCEDURE template_header(
      p_title VARCHAR2,
      p_ok_button VARCHAR2 DEFAULT NULL,
      p_cancel_button VARCHAR2 DEFAULT NULL)
   IS
   BEGIN
      htp.header( 3, p_title,cattributes => ' class="OraHeaderSub"');
      
      -- Top blue line
      htp.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0" width="90%"' );
      htp.tableRowOpen;
      htp.tableData( htf.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0" width="100%"' ) || 
         htf.tableRowOpen || 
         htf.tableData( '&nbsp;', cattributes => ' width="3%" class="OraBgColorDark"') || 
         htf.tableData( '<FONT class="OraGlobalPageTitle">' || 
         'Demo Shuttle Report' || 
         '</FONT>', cattributes => ' class="OraBgColorDark" width="96%"') || 
         htf.tableData( ' ', calign => 'RIGHT', cattributes => ' width="6%" valign="MIDDLE" class="OraBgColorDark"') || 
         htf.tableData( '&nbsp;', cattributes => ' class="OraBgColorDark"') || 
         htf.tableRowClose || 
         htf.tableClose);
      htp.tableRowClose;
      htp.tableRowOpen;
      htp.tableData( htf.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0" width="100%"' ) || 
         htf.tableRowOpen || 
         htf.tableData( htf.tableOpen(  cattributes => ' border="0" cellpadding="0" cellspacing="0"' ) || 
         htf.tableRowOpen || 
         htf.tableData( htf.img( '/images/FFFFFFsl.gif', calign => 'BOTTOM', calt => '', cattributes => ' border="0"                       valign="TOP"'), cattributes => ' valign="TOP" class="OraBgColorDark"') || 
         htf.tableRowClose || 
         htf.tableClose, cattributes => ' valign="TOP"') || 
         htf.tableData( ' ', cattributes => ' valign="TOP"') || 
         htf.tableData( '<DIV align="RIGHT">' || 
         '</DIV>', calign => 'RIGHT', cattributes => ' width="100%" valign="TOP"') || 
         htf.tableRowClose || 
         htf.tableClose);
      htp.tableRowClose;

      -- Top buttons;
      IF p_ok_button IS NOT NULL
      THEN 
         htp.tableRowOpen;
         htp.tableData( htf.tableOpen( calign => 'right',
               cattributes => ' border="0" cellpadding="1" cellspacing="4"' ) || 
            htf.tableRowOpen || 
            htf.tableData(p_ok_button) || 
            htf.tableData(p_cancel_button) || 
            htf.tableRowClose || 
            htf.tableClose, calign => 'RIGHT', cattributes => ' valign="TOP" width="100%"');
         htp.tableRowClose;
      END IF;
     
      htp.tableClose;

   END;


END;
