-- ********************************************************
--
-- A procedure to update the Desformat prompt globally
-- Run this as the user PORTAL. This was found on MetaLink.
-- This changes the contents of Portal core tables so use
-- it with care and at your own risk.
-- 
-- ********************************************************
PROCEDURE update_portal_prompts
IS
   CURSOR rls_cur
   IS
      SELECT object_name, policy_name
      FROM   user_policies
      WHERE  object_name = 'WWNLS_STRINGS$';
BEGIN
   DBMS_OUTPUT.ENABLE(100000);

   -- disable the policies
   FOR c1 IN rls_cur
   LOOP
      DBMS_OUTPUT.put_line('Disabling RLS on table ' || c1.object_name);
      DBMS_RLS.enable_policy(
         object_name => c1.object_name,
         policy_name => c1.policy_name,
         ENABLE => FALSE);
   END LOOP;

   UPDATE wwnls_strings$ 
   SET text='Output Type:' 
--
-- replace the subscriber_id and id below
-- with numbers that fit your installation
-- (check in this table owned by Portal for the Desformat prompt
-- and note the record's subscriber_id and id)
-- then uncomment the following line after substituting the values below
--   WHERE subscriber_id=0 AND id =70155;
--

   -- enable the policies
   FOR c1 IN rls_cur
   LOOP
      DBMS_OUTPUT.put_line('Enabling RLS on table ' || c1.object_name);
      DBMS_RLS.enable_policy(
         object_name => c1.object_name,
         policy_name => c1.policy_name,
         ENABLE => TRUE);
   END LOOP;
END;
